/*!
 * Neotwi
 * http://www.neo.co.jp/
 * Copyright (C) NEOJAPAN Inc. All Rights Reserved.
 * 本製品は日本国著作権法および国際条約により保護されています。 
 * 本製品の全部または一部を無断で複製したり、無断で複製物を頒 
 * 布すると著作権の侵害となりますのでご注意ください。 
 */
'use strict';

const remote        = require('electron').remote;
const browserWindow = remote.BrowserWindow;
const currentWindow = remote.getCurrentWindow();
const webFrame      = require('web-frame');
const session       = currentWindow.webContents.session;
const ipc           = window.require('electron').ipcRenderer;

function onLoad() {

  // BTMANTIS 0031719
  // ファイルのドロップを禁止
  $(document).on('drop dragstart dragover', function(e) {

    // BTMANTIS 0031909
    // dragstart
    if (e.type == 'dragstart') {
      // イベント発火元がresizerではない場合
      if (!$(e.target).hasClass('ui-layout-resizer')) {
        // イベントキャンセル
        e.preventDefault();
        return false;
      }
    }
    // drop、dragoverのイベントキャンセル
    else {
      e.preventDefault();
      return false;
    }
  });

  // 設定ファイルを読み込む
  var neoEnv = ipc.sendSync('getneoenv');
  var prefData = ipc.sendSync('getpreferences');
  var sessionData = ipc.sendSync('getsession');

  // ユーザー選択のレイアウト設定
  $('#jco-user-dispitems').val(neoEnv.userDispItems);

  // 表示項目設定
  $('#jco-usernodispitems').val(neoEnv.userHideItems);

  // core.jsの接続環境情報を上書きする
  desknets.msUrl = prefData.baseUrl;
  desknets._msExtension = prefData.cgiSuffix.replace(".", "");

  // セッション情報を上書きする値を取得する
  neo.msToken = sessionData.csrf_token;
  $.cookie("dnzToken", neo.msToken);

  var _cookies = [
    {url: desknets.msUrl, name: "dnzSid",     value: encodeURIComponent(sessionData.session_id)},
    {url: desknets.msUrl, name: "dnzToken",   value: sessionData.csrf_token}
  ];

  // Cookieセット
  var max = _cookies.length;
  for (var i=0; i < max; i++) {
    session.cookies.set(_cookies[i], function(error) {
      if (error) {
        console.error(error);
      }
    });
  }

  // chooser初期化
  desknets.chooser.init();

  // ダイアログ起動
  var $dialog = desknets.chooser.open('jntwi-user-chooser', {
    'choosePrivateGroup': true,
    'unassignGroup': 'readonly',
    'mode': 'single',
    'choose': function (items) {
      if (items.length > 0) {
        // BTMANTIS0031740
        ipc.send('selected-user', items[0]);
        currentWindow.close();
      }
    }
  });

  var options = {draggable: false, position: {my: 'left top', at: 'left top', of: 'body'}};
  $dialog.on('dialogopen', function( event, ui ) {
    $dialog.dialog("option", options);
  });

  $dialog.on('dialogclose', function( event, ui ) {
    currentWindow.close();
  });
}